/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.casting.actions.spells;

import at.petrak.hexcasting.api.casting.OperatorUtils;
import at.petrak.hexcasting.api.casting.ParticleSpray;
import at.petrak.hexcasting.api.casting.RenderedSpell;
import at.petrak.hexcasting.api.casting.castables.SpellAction;
import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.casting.eval.OperationResult;
import at.petrak.hexcasting.api.casting.eval.vm.CastingImage;
import at.petrak.hexcasting.api.casting.eval.vm.SpellContinuation;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.mishaps.Mishap;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\f\u0018\u00002\u00020\u0001:\u0001!B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ%\u0010\u0011\u001a\u00020\u00102\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0019\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001a\u001a\u0004\b\u001b\u0010\u001cR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001d\u001a\u0004\b\u001e\u0010\u001fR\u0017\u0010\b\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\u0013\u001a\u0004\b \u0010\u0015\u00a8\u0006\""}, d2={"Lat/petrak/hexcasting/common/casting/actions/spells/OpPotionEffect;", "Lat/petrak/hexcasting/api/casting/castables/SpellAction;", "Lnet/minecraft/class_1291;", "effect", "", "baseCost", "", "allowPotency", "potencyCubic", "<init>", "(Lnet/minecraft/class_1291;JZZ)V", "", "Lat/petrak/hexcasting/api/casting/iota/Iota;", "args", "Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;", "env", "Lat/petrak/hexcasting/api/casting/castables/SpellAction$Result;", "execute", "(Ljava/util/List;Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;)Lat/petrak/hexcasting/api/casting/castables/SpellAction$Result;", "Z", "getAllowPotency", "()Z", "", "getArgc", "()I", "argc", "J", "getBaseCost", "()J", "Lnet/minecraft/class_1291;", "getEffect", "()Lnet/minecraft/class_1291;", "getPotencyCubic", "Spell", "hexcasting-fabric-1.20.1"})
public final class OpPotionEffect
implements SpellAction {
    @NotNull
    private final class_1291 effect;
    private final long baseCost;
    private final boolean allowPotency;
    private final boolean potencyCubic;

    public OpPotionEffect(@NotNull class_1291 effect, long baseCost, boolean allowPotency, boolean potencyCubic) {
        Intrinsics.checkNotNullParameter((Object)effect, (String)"effect");
        this.effect = effect;
        this.baseCost = baseCost;
        this.allowPotency = allowPotency;
        this.potencyCubic = potencyCubic;
    }

    @NotNull
    public final class_1291 getEffect() {
        return this.effect;
    }

    public final long getBaseCost() {
        return this.baseCost;
    }

    public final boolean getAllowPotency() {
        return this.allowPotency;
    }

    public final boolean getPotencyCubic() {
        return this.potencyCubic;
    }

    @Override
    public int getArgc() {
        return this.allowPotency ? 3 : 2;
    }

    @Override
    @NotNull
    public SpellAction.Result execute(@NotNull List<? extends Iota> args, @NotNull CastingEnvironment env) {
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        class_1309 target = OperatorUtils.getLivingEntityButNotArmorStand(args, 0, this.getArgc());
        double duration = OperatorUtils.getPositiveDouble(args, 1, this.getArgc());
        double potency = this.allowPotency ? OperatorUtils.getDoubleBetween(args, 2, 1.0, 127.0, this.getArgc()) : 1.0;
        env.assertEntityInRange((class_1297)target);
        double cost = (double)this.baseCost * duration * (this.potencyCubic ? potency * potency * potency : potency * potency);
        RenderedSpell renderedSpell = new Spell(this.effect, target, duration, potency);
        long l = (long)cost;
        class_243 class_2432 = target.method_19538().method_1031(0.0, (double)target.method_5751() / 2.0, 0.0);
        Intrinsics.checkNotNullExpressionValue((Object)class_2432, (String)"target.position().add(0.\u2026get.eyeHeight / 2.0, 0.0)");
        return new SpellAction.Result(renderedSpell, l, CollectionsKt.listOf((Object)ParticleSpray.Companion.cloud$default(ParticleSpray.Companion, class_2432, 1.0, 0, 4, null)), 0L, 8, null);
    }

    @Override
    public boolean hasCastingSound(@NotNull CastingEnvironment ctx) {
        return SpellAction.DefaultImpls.hasCastingSound(this, ctx);
    }

    @Override
    public boolean awardsCastingStat(@NotNull CastingEnvironment ctx) {
        return SpellAction.DefaultImpls.awardsCastingStat(this, ctx);
    }

    @Override
    @NotNull
    public SpellAction.Result executeWithUserdata(@NotNull List<? extends Iota> args, @NotNull CastingEnvironment env, @NotNull class_2487 userData) throws Mishap {
        return SpellAction.DefaultImpls.executeWithUserdata(this, args, env, userData);
    }

    @Override
    @NotNull
    public OperationResult operate(@NotNull CastingEnvironment env, @NotNull CastingImage image, @NotNull SpellContinuation continuation) {
        return SpellAction.DefaultImpls.operate(this, env, image, continuation);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\r\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\b\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\u0010\u001a\u0004\b\u0016\u0010\u0012R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lat/petrak/hexcasting/common/casting/actions/spells/OpPotionEffect$Spell;", "Lat/petrak/hexcasting/api/casting/RenderedSpell;", "Lnet/minecraft/class_1291;", "effect", "Lnet/minecraft/class_1309;", "target", "", "duration", "potency", "<init>", "(Lnet/minecraft/class_1291;Lnet/minecraft/class_1309;DD)V", "Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;", "env", "", "cast", "(Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;)V", "D", "getDuration", "()D", "Lnet/minecraft/class_1291;", "getEffect", "()Lnet/minecraft/class_1291;", "getPotency", "Lnet/minecraft/class_1309;", "getTarget", "()Lnet/minecraft/class_1309;", "hexcasting-fabric-1.20.1"})
    private static final class Spell
    implements RenderedSpell {
        @NotNull
        private final class_1291 effect;
        @NotNull
        private final class_1309 target;
        private final double duration;
        private final double potency;

        public Spell(@NotNull class_1291 effect, @NotNull class_1309 target, double duration, double potency) {
            Intrinsics.checkNotNullParameter((Object)effect, (String)"effect");
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            this.effect = effect;
            this.target = target;
            this.duration = duration;
            this.potency = potency;
        }

        @NotNull
        public final class_1291 getEffect() {
            return this.effect;
        }

        @NotNull
        public final class_1309 getTarget() {
            return this.target;
        }

        public final double getDuration() {
            return this.duration;
        }

        public final double getPotency() {
            return this.potency;
        }

        @Override
        public void cast(@NotNull CastingEnvironment env) {
            Intrinsics.checkNotNullParameter((Object)env, (String)"env");
            if (this.duration > 0.05) {
                class_1293 effectInst = new class_1293(this.effect, (int)(this.duration * (double)20), (int)this.potency - 1);
                this.target.method_6092(effectInst);
            }
        }

        @Override
        @Nullable
        public CastingImage cast(@NotNull CastingEnvironment env, @NotNull CastingImage image) {
            return RenderedSpell.DefaultImpls.cast(this, env, image);
        }
    }
}

